/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.internal.action.RepositoryAdd;
import de.willuhn.jameica.gui.internal.action.RepositoryDisable;
import de.willuhn.jameica.gui.internal.action.RepositoryEnable;
import de.willuhn.jameica.gui.internal.parts.RepositoryList;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.util.ApplicationException;
import org.eclipse.swt.widgets.Composite;

public class RepositoryEditDialog
extends AbstractDialog<Void> {
    public RepositoryEditDialog(int position) {
        super(position);
        this.setTitle(this.i18n.tr("Plugin-Repositories"));
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent, true);
        container.addText(this.i18n.tr("Sie k\u00f6nnen ein Repository l\u00f6schen, indem Sie mit der rechten Maustaste auf das betreffende Repository klicken und \"L\u00f6schen...\" bzw. \"Deaktivieren...\" w\u00e4hlen."), true);
        RepositoryList list = new RepositoryList();
        Button disable = new Button(this.i18n.tr("Deaktivieren..."), e -> new RepositoryDisable().handleAction(list.getSelection()), null, false, "network-offline.png");
        disable.setEnabled(false);
        Button enable = new Button(this.i18n.tr("Aktivieren..."), e -> new RepositoryEnable().handleAction(list.getSelection()), null, false, "network-transmit-receive.png");
        enable.setEnabled(false);
        list.addSelectionListener(e -> {
            RepositoryList.RepositoryEntry entry = (RepositoryList.RepositoryEntry)e.data;
            disable.setEnabled(entry.isEnabled());
            enable.setEnabled(!entry.isEnabled());
        });
        container.addPart(list);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(enable);
        buttons.addButton(disable);
        buttons.addButton(this.i18n.tr("Neues Repository hinzuf\u00fcgen..."), new RepositoryAdd(), null, false, "document-new.png");
        buttons.addButton(this.i18n.tr("Schlie\u00dfen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                RepositoryEditDialog.this.close();
            }
        }, null, false, "window-close.png");
        container.addButtonArea(buttons);
        this.setSize(700, 500);
    }

    @Override
    protected Void getData() throws Exception {
        return null;
    }
}

